#include <windows.h>
#include "generic.h"
#include "resource.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#if defined (win32)
   #define IS_WIN32 TRUE
#else
   #define IS_WIN32 FALSE
#endif

HINSTANCE hInst;        // current instance

int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
 {  
   hInst = hInstance;
   srand( (unsigned) time(NULL));
   DialogBox(hInst, MAKEINTRESOURCE( IDD_DIALOG1 ), 0, (DLGPROC)gen);

   return(0);
 }


LRESULT CALLBACK gen( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	char username[255]="", serial[255]="RKS-";
	int seed,i;
	DWORD sn;

	switch (uMsg)
	{
	case WM_COMMAND :
		switch (LOWORD (wParam))
		{
		case IDGEN :
			GetDlgItemText( hDlg, IDC_USERINPUT, username, 255);
			// put key generation code here!!
			if ( lstrlen( username) == 0)
			{
				MessageBox(0,"You must enter a string!","Error",MB_ICONERROR | MB_OK);
				break;
			}
			// uppercase the username
			_strupr( username);

			// initialize a 1 out of 4 random seed
			seed = rand();
			seed /= 8192;
			sn=0;

			switch ( seed)
			{
			case 0 :
				seed = 0x1b54;
			break;
			case 1 :
				seed = 0x1b1f;
			break;
			case 2 :
				seed = 0x1771;
			break;
			case 3 :
				seed = 0x17d9;
			break;

			default : seed = 0x17d9;
			}
			// now make serial
			for ( i=0 ; i < lstrlen( username) ; i++)
			{
				if ( username[i] != ' ')
				{
					sn += seed * username[i];
					sn--;
				}
			}
			sprintf( username, "%d", sn);
			lstrcat( serial, username);

			//finish and bug out!
			SetDlgItemText( hDlg, IDC_RESULTKEY, serial);
			break;
		case IDEXIT :
			EndDialog( hDlg, IDEXIT);
			break;
		}
	break;

	case WM_DESTROY : 
		EndDialog( hDlg, IDEXIT);
	break;

	default : return(FALSE);
	}
return(TRUE);

}
